/************************************************************************** 
GAUSS code: Exercise 5.4(a), replicate results in Table 5.3
File: Table 53.g
   
Modification of computer code written by Jean-Yves Pitarakis.
 
This program implements the SupLM test statistic
The test is performed on a correctly specified model as well as 
on models specified using a model selection criterion. 
The program makes use of the TAR.PRC routine written by Bruce Hansen.  
  
Reference:
Pitarakis, J.-Y. (2006). Model selection uncertainty and detection of 
   threshold effects.
   Studies in Nonlinear Dynamics & Econometrics, 10(1), 1-30.
   DOI: 10.2202/1558-3708.1256.
************************************************************************* */
new;
format /m1 /ldn 6,4;
/* output file=sizesup.out reset; */

t = 200+50;        @ Sample Size @
y = zeros(t,1);
n = 2000;          @ Number of MC replications @

paic   = zeros(n,1); @ Various Initialisations @
pbic   = zeros(n,1);
phic   = zeros(n,1);

lm     = zeros(n,1);
lmr    = zeros(n,1);
pval   = zeros(n,1);
pvalr  = zeros(n,1);

lma    = zeros(n,1);
lmra   = zeros(n,1);
pvala  = zeros(n,1);
pvalra = zeros(n,1);

lmb    = zeros(n,1);
lmrb   = zeros(n,1);
pvalb  = zeros(n,1);
pvalrb = zeros(n,1);

lmh    = zeros(n,1);
lmrh   = zeros(n,1);
pvalh  = zeros(n,1);
pvalrh = zeros(n,1);

pmax = 6; @ Maximum Lag Length @

/* Model Exercise 5.4 DGP (i) */
   f01 = 0.5;f11=0.2;f21=-0.1; f02=0.3;f12=-0.2;f22=0.1;


/*
/* Model Exercise 5.4 DGP (ii) */
   f01 = 0.5;f11=-0.1;f21=0.1; f02=0.3;f12=0.1;f22=-0.1;
*/

j=1; @ Looping over replications @
do while j<=n;
   e = rndn(t,1);

   i = 3;
   do while i<=t;
      y[i] = (f01+f11*y[i-1]+f21*y[i-2])*(y[i-2]<=0)+
      (f02+f12*y[i-1]+f22*y[i-2])*(y[i-2]>0)+e[i];
      i = i+1;
   endo;

   z = y[51:t];

   lagvec=lagsel(z,pmax); @ Selecting phat with AIC, BIC and HQ @

   paic[j] = lagvec[1,1];
   pbic[j] = lagvec[2,1];
   phic[j] = lagvec[3,1];

   {tests,pvals}   = tar(z,2,0,0.10,0.90,100);       @ SupLM test with p=p0 @
   {testsa,pvalsa} = tar(z,paic[j],0,0.10,0.90,100); @ SupLM with p=paic @
   {testsb,pvalsb} = tar(z,pbic[j],0,0.10,0.90,100); @ SupLM with p=pbic @
   {testsh,pvalsh} = tar(z,phic[j],0,0.10,0.90,100); @ SupLM with p=phic @

   lmr[j]    = tests[1]; /* Correctly Specified */
   pvalr[j]  = pvals[1];
   lm[j]     = tests[4];
   pval[j]   = pvals[4];

   lmra[j]   = testsa[1];  /* Specified with AIC */
   pvalra[j] = pvalsa[1];
   lma[j]    = testsa[4];
   pvala[j]  = pvalsa[4];

   lmrb[j]   = testsb[1]; /* Specified with BIC */
   pvalrb[j] = pvalsb[1];
   lmb[j]    = testsb[4];
   pvalb[j]  = pvalsb[4];

   lmrh[j]   = testsh[1]; /* Specified with HQ */
   pvalrh[j] = pvalsh[1];
   lmh[j]    = testsh[4];
   pvalh[j]  = pvalsh[4];

   veco1     = lm[j]~pval[j];
   veco2     = lma[j]~pvala[j];
   veco3     = lmb[j]~pvalb[j];
   veco4     = lmh[j]~pvalh[j];
/*   j~veco1~veco2~veco3~veco4;  */
   j = j+1;
endo;

"";
"2.5% ------------------------5%----------10%---Standard SupLM";
((counts(pval,0.025)/n))~((counts(pval,0.05)/n))~((counts(pval,0.10)/n));

"2.5% ------------------------5%----------AIC---Standard SupLM";
((counts(pvala,0.025)/n))~((counts(pvala,0.05)/n))~((counts(pvala,0.10)/n));

"2.5% ------------------------5%-----------BIC----Standard SupLM";
((counts(pvalb,0.025)/n))~((counts(pvalb,0.05)/n))~((counts(pvalb,0.10)/n));
"2.5% ------------------------5%-----------HQ--Standard SupLM";
((counts(pvalh,0.025)/n))~((counts(pvalh,0.05)/n))~((counts(pvalh,0.10)/n));

"";
"";
"Lag Lengths Selected: over 2000 MC replications";
toto = seqa(1,1,pmax);
toto~counts(paic,toto)/n~counts(pbic,toto)/n~counts(phic,toto)/n;

/* output off; */

/* Procedures */
/*

TAR.PRC
This program estimates a p'th order threshold autoregression and tests the
hypothesis of a linear autoregression.
The procedure is a function of eight inputs, and takes the form

  {tests,pvalues} = tar(y,p,omit,r1,r2,rep);

The inputs are:
y     =  the vector of observations
p     =  the order of the autoregression
omit  =  lags (below p) to omit from autoregression [0 implies an AR(p)]
r1    =  the lower quantile
r2    =  the upper quantile
rep   =  number of simulation replications

Additional detail on inputs:
p       should be a positive integer

omit    if 0, then an AR(p) model is used
        if a positive integer, then that AR lag is omitted from model
        if a vector of positive integers, then all these lags are omitted

There are two output vectors, the first contains the test statistics, and the
second the estimated asymptotic p-values.  The statistics (in order) are:
SupLM, ExpLM, AveLM, SupLMs, ExpLMs, AveLMs.

*/

proc(2) = tar(dat,p,omit,r1,r2,rep);

local t,k,y,x,j,s,m,mi,bnull,u,sig,xu,v,se,ses,t1,t2,tn,xr,k1,
lm,lms,yx,sim,d,xs,ys,r,br,ur,xruw,vrwt,dm,rm,olslab,
xrulm,vrlmt,wlms,sigr,vht,sims,missim,xusim,dri,vrw,
mr,xsr,xt,xti,xs1,sig1,sig2,xtu,misim,xrsim,xsu,
wrep,mrep,zt,tnk,t1r,xz1,x1,sim1,zi,zr,xz,xz2,zrt,
dtnr,supwk,indv,arv,ars,tests,pvalues,dr,su,ar,sel,kx,
fmt16,tnames,z,th,reg1,reg2,bss,rg,thn,dmn,ttp,ro,tk1,tk2,
wmax,wsum,wsume,lmmax,lmsum,lmsume,smax,ssum,ssume,srep,
supws,suplms,xmi,wh,lmh,vrwh,vrlmh,xtt1,xtt2,mrir,mririr;

@ Construct Data @

t = rows(dat)-p;
k = p;

k1  = k+1;
tk1 = t-k1;
tk2 = t-k1*2;
y   = dat[1+p:t+p];
x   = ones(t,1);
j=1;do while j<=p;
if sumc(omit.==j)==0;
 x = x~dat[1+p-j:t+p-j];
endif;
j = j+1;endo;

@ Null Model @
s     = x'y;
m     = moment(x,0);
mi    = invpd(m);
bnull = mi*s;
u     = y-x*bnull;
sig   = (u'u)/tk1;


kx = sumc((x').*(mi*(x')));
xu = x.*(u./(1-kx));
xu = xu-(meanc(xu)');
v  = moment(xu,0);
se = sqrt(diag(mi*v*mi));

@ Test Statistic Storage @

t1 = round(t*r1);
t2 = round(t*r2);
tn = t2-t1;

lm    = zeros(tn,k); lms = lm;  sigr = lm;
lmmax = zeros(rep,1); lmsum = lmmax; lmsume = lmmax;
smax  = lmmax; ssum = lmmax; ssume = lmmax;

sim    = rndn(t,rep);
xu     = x.*u;
xmi    = x*mi;
misim  = xmi'sim;
missim = mi*(xu'sim);

d=1;do while d<=k;            @ Pick Threshold Variable   @ 

z    = rankindx(x[.,d+1],1);
zi   = sortc((z~seqa(1,1,t)),1);
zr   = zi[.,2];

xr   = x.*(z.<=t1);
xz1  = zr[1:t1];
x1   = x[xz1,.];
mr   = moment(x1,0);
sim1 = sim[xz1,.];

xrsim = x1'sim1;
xusim = xu[xz1,.]'sim1;

r=1;do while r<=tn;           @ Pick Threshold   @
t1r = t1+r;
xz  = zr[1:t1r];
xz2 = zr[t1r+1:t];
zrt = zr[t1r];
xsr = x[zrt,.];
xr[zrt,1:k1] = xsr;
mr   = mr+xsr'xsr;
xt   = xr-xmi*mr;
mrir = mr*mi*mr;
xti  = invpd(mr-mrir);
xtu  = xr'u;
br   = xti*xtu;
ur   = u-xt*br;
sigr[r,d]=ur'ur;

xrulm=xt.*u;
vrlmt=invpd(moment(xrulm,0));
lm[r,d]=xtu'vrlmt*xtu;            @  LM Statistic  @
lms[r,d]=(xtu'xti*xtu)/sig;       @ Standard LM Statistic   @

@ Simulation Manipulations @

xrsim=xrsim+xsr'sim[zrt,.];
sims=xrsim-mr*misim;
wrep=sumc(sims.*(xti*sims));
smax=maxc((smax')|(wrep'));
ssum=ssum+wrep;
ssume=ssume+exp(wrep/2);

xusim=xusim+xu[zrt,.]'sim[zrt,.];
sims=xusim-mr*missim;
wrep=sumc(sims.*(vrlmt*sims));
lmmax=maxc((lmmax')|(wrep'));
lmsum=lmsum+wrep;
lmsume=lmsume+exp(wrep/2);

r=r+1; endo;
d=d+1; endo; 

clear sim,misim,missim;

@ Test Statistics @
tests =
maxc(maxc(lm))|ln(meanc(meanc(exp(lm/2))))|meanc(meanc(lm))|
maxc(maxc(lms))|ln(meanc(meanc(exp(lms/2))))|meanc(meanc(lms));

@ P-values @

tnk=tn*k;
ssum=ssum/tnk;
lmsum=lmsum/tnk;
ssume=ln(ssume/tnk);
lmsume=ln(lmsume/tnk);

pvalues=meanc((lmmax~lmsume~lmsum~smax~ssume~ssum) .> (tests'));

retp(tests,pvalues);
endp;

/*   Procedures */
/*
LAGSEL

This procedure fits AR(p) models to the data and selects the optimal lag length
using the AIC, BIC and HQ criteria. It takes the data and the maximum lag 
length as inputs.
Note: p is assumed to lie in the [1,pmax] interval
*/

proc (1) = lagsel(dat,maxlag);
local laic,lbic,lhic,k,y,h,yr,z,beta,res,rres,plinaic,plinbic,plinhic,n;

laic=zeros(maxlag,1);
lbic=zeros(maxlag,1);
lhic=zeros(maxlag,1);
n=rows(dat);

k=1;
do while k<=maxlag;
y=dat[k+1:n];

h=1;
do while h<=k;
y=y~dat[k+1-h:n-h];
h=h+1;
endo;

yr=y[.,1];
z=ones(rows(yr),1)~y[.,2:cols(y)];
beta=yr/z;
res=yr-z*beta;
rres=rows(res);
laic[k]=ln(res'res/rres)+(2/rres)*(k+1);
lbic[k]=ln(res'res/rres)+(ln(rres)/rres)*(k+1);
lhic[k]=ln(res'res/rres)+(2*ln(ln(rres))/rres)*(k+1);
k=k+1;
endo;
plinaic=minindc(laic)~minc(laic);
plinbic=minindc(lbic)~minc(lbic);
plinhic=minindc(lhic)~minc(lhic);

retp(plinaic|plinbic|plinhic);
endp;

